<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package thim
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?><?php
if ( is_rtl() ) {
	echo " dir=\"rtl\"";
} ?>
>
<head>
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-151602684-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-151602684-1');
</script>


	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php esc_url( bloginfo( 'pingback_url' ) ); ?>">
	<?php
	$custom_sticky = $class_header = '';
	if ( get_theme_mod( 'thim_rtl_support' ) == true ) {
		$class_header .= 'rtl';
	}
	if ( get_theme_mod( 'thim_config_att_sticky' ) == 'sticky_custom' ) {
		$custom_sticky .= ' bg-custom-sticky';
	}
	if ( get_theme_mod( 'thim_header_sticky' ) == 1 ) {
		$custom_sticky .= ' sticky-header';
	}
	if ( get_theme_mod( 'thim_header_position' ) ) {
		$custom_sticky .= ' header_overlay';
		$class_header  .= ' wrapper-header_overlay';
	}

	$header_style  = get_theme_mod( 'thim_header_style' );
	$custom_sticky .= ' ' . $header_style;
	$class_header  .= ' wrapper-' . $header_style;

	if ( get_theme_mod( 'thim_box_layout' ) == 'boxed' ) {
		$class_boxed = 'boxed-area';
	} else {
		$class_boxed = '';
	}

	wp_head();
	?>
	

<script type="text/javascript">
	jQuery(window).load(function () {
	    function limpaPainel(){
	        jQuery('.painel').hide();
	        jQuery('.elementor-element .painel-ativo').removeClass('painel-ativo');
	    }
	    function mostraPainel(painel){
	       limpaPainel();
	       jQuery('.painel-'+ painel).show('fast');
	       jQuery('.elementor-element .link-'+ painel).addClass('painel-ativo');
           
	       setTimeout(function(){
	            var vtop = jQuery('#' + painel).offset().top - 25;
                jQuery("html, body").animate({ scrollTop: vtop }, 500);
            }, 500);
            	        
	    }
	    jQuery('.link-restaurants').on('click', function(){
	        mostraPainel('restaurants');
	    });
	    
	    jQuery('.link-travel').on('click', function(){
	        mostraPainel('travel');
	    });
	    
	    jQuery('.link-events').on('click', function(){
	        mostraPainel('events');
	    });
	    
        var hash = window.location.hash
        if ( hash == '' || hash == '#' || hash == undefined ) return false;
        if(hash){
            hash = hash.replace('#', '');
            mostraPainel(hash);
        }
	});
</script>

</head>

<body <?php body_class( $class_header ); ?>>

<?php do_action( 'thim_before_body' ); ?>

<?php if ( get_theme_mod( 'thim_preload' ) == 1 ) { ?>
	<div id="preload">
		<div class="loading-inner">
			<div class="loading loading-1"></div>
			<div class="loading loading-2"></div>
			<div class="loading loading-3"></div>
			<div class="loading loading-4"></div>
			<div class="loading loading-5"></div>
			<div class="loading loading-6"></div>
			<div class="loading loading-7"></div>
			<div class="loading loading-8"></div>
			<div class="loading loading-9"></div>
		</div>
	</div>
<?php } else {
	if ( get_theme_mod( 'thim_preload' ) == "image" ) { ?>
		<div id="preload">
			<div class="loading-inner">
				<?php
				do_action( 'thim_preload_image' );
				?>
			</div>
		</div>
	<?php }
} ?>
<div id="wrapper-container" class="wrapper-container">
	<div class="content-pusher <?php echo esc_attr( $class_boxed ); ?>">
		<header id="masthead" class="site-header affix-top<?php echo esc_attr( $custom_sticky ); ?>">
			<?php
			// Drawer
			if ( get_theme_mod( 'thim_show_drawer' ) == true && is_active_sidebar( 'drawer_top' ) ) {
				get_template_part( 'inc/header/drawer' );
			}

			if ( 'header_v2' === get_theme_mod( 'thim_header_style' ) ) {
				get_template_part( 'inc/header/header_v2' );
			} elseif ( 'header_v3' === get_theme_mod( 'thim_header_style' ) ) {
				get_template_part( 'inc/header/header_v3' );
			} else {
				get_template_part( 'inc/header/header_v1' );
			}

			?>
		</header>
		<div id="main-content">
