<?php
if ( class_exists( 'THIM_Testimonials' ) ) {
	class Testimonials_Widget extends Thim_Widget {
		function __construct() {
			parent::__construct(
				'testimonials',
				esc_attr__( 'Thim: Testimonials', 'sailing' ),
				array(
					'description'   => esc_attr__( 'Testimonial ThimPress.', 'sailing' ),
					'help'          => '',
					'panels_groups' => array( 'thim_widget_group' ),
					'panels_icon'   => 'dashicons dashicons-welcome-learn-more'
				),
				array(),
				array(
					'style'         => array(
						"type"          => "select",
						"label"         => esc_attr__( "Style testimonial", "sailing" ),
						"default"       => "base",
						"options"       => array(
							"base"    => esc_attr__( "Style Old", "sailing" ),
							"default" => esc_attr__( "Style New", "sailing" )
						),
						'state_emitter' => array(
							'callback' => 'select',
							'args'     => array( 'style' )
						)
					),
					'title' => array(
						'type'                  => 'text',
						'label'                 => esc_attr__( 'Heading Text', 'sailing' ),
						'default'               => esc_attr__( 'Testimonials', 'sailing' ),
						'allow_html_formatting' => true,
						'state_handler' => array(
							'style[base]'    => array( 'show' ),
							'style[default]' => array( 'hide' ),
						),
					),

					'number' => array(
						'type'    => 'number',
						'label'   => esc_attr__( 'Number Posts', 'sailing' ),
						'default' => '4'
					),
					'time'   => array(
						'type'    => 'number',
						'label'   => esc_attr__( 'Autoplay Timeout', 'sailing' ),
						'default' => '10000'
					),

				),
				TP_THEME_DIR . 'inc/widgets/testimonials/'
			);
		}

		/**
		 * Initialize the CTA widget
		 */


		function get_template_name( $instance ) {
			return isset( $instance['style'] ) ? $instance['style'] : 'base';
		}

		function get_style_name( $instance ) {
			return false;
		}

	}

	function thim_testimonials_register_widget() {
		register_widget( 'Testimonials_Widget' );
	}

	add_action( 'widgets_init', 'thim_testimonials_register_widget' );
}