<?php
/**
 * The template for displaying archive room.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/archive-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
?>

<?php
global $post, $wp_query;
$total = $wp_query->found_posts;

if ( $total == 0 ) {
	$message = '<p class="message message-error">' . esc_html__( 'No room found!', 'sailing' ) . '</p>';
	$index   = esc_html__( 'There are no available room!', 'sailing' );
} elseif ( $total == 1 ) {
	$index = esc_html__( 'Showing only one result', 'sailing' );
} else {
	$room_per_page_get = get_option( 'tp_hotel_booking_posts_per_page' );
	$room_per_page     = is_numeric( $room_per_page_get ) ? $room_per_page_get : 12;
	$paged             = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;

	$from = 1 + ( $paged - 1 ) * $room_per_page;
	$to   = ( $paged * $room_per_page > $total ) ? $total : $paged * $room_per_page;

	if ( $from == $to ) {
		$index = sprintf(
			esc_html__( 'Showing last room of %s results', 'sailing' ),
			$total
		);
	} else {
		$index = sprintf(
			esc_html__( 'Showing %s-%s of %s results', 'sailing' ),
			$from,
			$to,
			$total
		);
	}
}
$cookie_name = 'room_switch';
$layout      = ( !empty( $_COOKIE[$cookie_name] ) ) ? $_COOKIE[$cookie_name] : 'grid-layout';

/**
 * hotel_booking_before_main_content hook
 *
 * @hooked hotel_booking_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked hotel_booking_breadcrumb - 20
 */
do_action( 'hotel_booking_before_main_content' );
?>

<?php
/**
 * hotel_booking_archive_description hook
 *
 * @hooked hotel_booking_taxonomy_archive_description - 10
 * @hooked hotel_booking_room_archive_description - 10
 */
do_action( 'hotel_booking_archive_description' );
?>

<?php if ( have_posts() ) : ?>

	<?php
	/**
	 * hotel_booking_before_shop_loop hook
	 *
	 * @hooked hotel_booking_result_count - 20
	 * @hooked hotel_booking_catalog_ordering - 30
	 */
	do_action( 'hotel_booking_before_shop_loop' );
	?>

	<div class="thim-room-top switch-layout-container">
		<div class="thim-room-switch-layout switch-layout">
			<a href="#" class="list switchToGrid<?php echo ( $layout == 'grid-layout' ) ? ' switch-active' : ''; ?>"><i class="fa fa-th-large"></i></a>
			<a href="#" class="grid switchToList<?php echo ( $layout == 'list-layout' ) ? ' switch-active' : ''; ?>"><i class="fa fa-list-ul"></i></a>
		</div>
		<div class="room-index">
			<span><?php echo( $index ); ?></span>
		</div>
	</div>

	<?php hotel_booking_room_loop_start(); ?>

	<?php hotel_booking_room_subcategories(); ?>

	<div id="thim-room-archive" class="<?php echo ( $layout == 'list-layout' ) ? 'thim-room-list' : 'thim-room-grid'; ?>" data-cookie="grid-layout">
		<?php while ( have_posts() ) : the_post(); ?>

			<?php hb_get_template_part( 'content', 'room' ); ?>

		<?php endwhile; // end of the loop. ?>
	</div>

	<?php hotel_booking_room_loop_end(); ?>

	<?php
	/**
	 * hotel_booking_after_shop_loop hook
	 *
	 * @hooked hotel_booking_pagination - 10
	 */
	do_action( 'hotel_booking_after_shop_loop' );
	?>

<?php endif; ?>

<?php
/**
 * hotel_booking_after_main_content hook
 *
 * @hooked hotel_booking_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'hotel_booking_after_main_content' );
?>

<?php
/**
 * hotel_booking_sidebar hook
 *
 * @hooked hotel_booking_get_sidebar - 10
 */
do_action( 'hotel_booking_sidebar' );
?>


<?php
do_action( 'hotel_booking_after_room_loop' );
?>