<?php
/**
 * The template for displaying single room gallery.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/gallery.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_room;
/**
 * @var $hb_room WPHB_Room
 */
$galleries = $hb_room->get_galleries( false );
?>

<?php if ( $galleries ): ?>
	<div class="hb_room_gallery flexslider" id="slider">
		<ul class="slides">
			<?php foreach ( $galleries as $key => $gallery ): ?>
				<li><img src="<?php echo esc_url( $gallery['src'] ) ?>"></li>
			<?php endforeach; ?>
		</ul>
	</div>
	<div class="hb_room_gallery flexslider" id="carousel">
		<ul class="slides">
			<?php foreach ( $galleries as $key => $gallery ): ?>
				<li><img src="<?php echo esc_url( $gallery['src'] ) ?>"></li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>